<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Event extends Model 
{

    protected $table = 'events';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function webhooks()
    {
        return $this->hasMany('App\Models\Webhooks');
    }

    public function eventable()
    {
        return $this->morphTo();
    }

}